/* Copyright (C) 2017-2018 RealVNC Ltd.  All Rights Reserved.
 */

#ifndef LOCKEDEVENTHANDLEAUTOPTRQUEUE_H_204402103861869830296793198199199956659
#define LOCKEDEVENTHANDLEAUTOPTRQUEUE_H_204402103861869830296793198199199956659

#include <vnccommon/EventHandleAutoPtrQueue.h>
#include <vnccommon/Mutex.h>

/**
 * \cond VNCCOMMON
 */
namespace vnccommon
{

/**
 * \brief The provided event handle is readable when there are items in the
 * queue.
 */
template<typename T>
class LockedEventHandleAutoPtrQueue
{
    VNCCOMMON_DISALLOW_COPYING(LockedEventHandleAutoPtrQueue);

public:
    LockedEventHandleAutoPtrQueue()
    {
    }

    void enqueue(std::auto_ptr<T> value)
    {
        Mutex::Locker locker(mMutex);
        mQueue.enqueue(value);
    }

    OptionalAutoPtr<T> tryDequeue()
    {
        Mutex::Locker locker(mMutex);
        return mQueue.tryDequeue();
    }

    EventHandle getEventHandle() const
    {
        return mQueue.getEventHandle();
    }

    DirectedEventHandle getDirectedEventHandle() const
    {
        return mQueue.getDirectedEventHandle();
    }

private:
    Mutex mMutex;
    EventHandleAutoPtrQueue<T> mQueue;
};

}
/**
 * \endcond
 */

#endif // LOCKEDEVENTHANDLEAUTOPTRQUEUE_H_204402103861869830296793198199199956659

